/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.util.DogFoodUtil;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.InventoryUtil;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PackPuppyTalent
extends TalentInstance {
    public static final int MAX_DOG_INV_VIEW = 8;
    private boolean renderChest = true;
    private boolean pickupItems = true;
    private boolean offerFood = true;
    private boolean collectKillLoot = true;
    private PackPuppyItemHandler packPuppyHandler;
    private MeatFoodHandler meatFoodHandler = new MeatFoodHandler(){

        @Override
        public boolean isFood(ItemStack stack) {
            FoodProperties props = stack.m_41720_().m_41473_();
            if (props == null) {
                return false;
            }
            return stack.m_41614_() && props.m_38746_() && stack.m_41720_() != Items.f_42583_ && props.m_38744_() >= 6;
        }
    };
    private final double COLLECT_RADIUS = 2.0;
    private int tickTillUpdateCollect = 10;
    private final int TRIGGER_RADIUS = 12;
    private int tickTillUpdateFood = 30;
    private static int NOTIFY_RADIUS = 20;

    public PackPuppyTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
        PackPuppyItemHandler handler;
        this.packPuppyHandler = handler = new PackPuppyItemHandler();
    }

    public PackPuppyItemHandler inventory() {
        return this.packPuppyHandler;
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (!dogIn.isDoingFine()) {
            return;
        }
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        this.tickDogCollectItems(dogIn);
        this.tickOfferFoodToTeammate(dogIn);
    }

    public boolean canCollectItems() {
        return this.level() >= 3;
    }

    public boolean canOfferFood() {
        return this.level() >= 4;
    }

    private void tickDogCollectItems(AbstractDog dog) {
        if (dog.m_9236_().f_46443_) {
            return;
        }
        if (!this.canCollectItems() || !this.pickupItems) {
            return;
        }
        if (--this.tickTillUpdateCollect > 0) {
            return;
        }
        this.tickTillUpdateCollect = 10;
        List itemList = dog.m_9236_().m_6443_(ItemEntity.class, dog.m_20191_().m_82377_(2.0, 1.0, 2.0), PackPuppyTalent::eligibleItemToPickUp);
        if (itemList.isEmpty()) {
            return;
        }
        for (ItemEntity entity : itemList) {
            ItemStack remaining = InventoryUtil.addItem((IItemHandler)this.packPuppyHandler, entity.m_32055_());
            if (!remaining.m_41619_()) {
                entity.m_32045_(remaining);
                continue;
            }
            entity.m_146870_();
            dog.m_5496_(SoundEvents.f_12019_, 0.25f, ((dog.m_217043_().m_188501_() - dog.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public static boolean eligibleItemToPickUp(ItemEntity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity.m_32063_()) {
            return false;
        }
        ItemStack stack = entity.m_32055_();
        return !stack.m_204117_(DoggyTags.PACK_PUPPY_BLACKLIST);
    }

    private void tickOfferFoodToTeammate(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (!this.canOfferFood() || !this.offerFood) {
            return;
        }
        if (--this.tickTillUpdateFood > 0) {
            return;
        }
        this.tickTillUpdateFood = 60;
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (!this.hasFood(dog, dog)) {
            return;
        }
        List<Dog> hungry_dogs = this.getNearbyHungryDogs(dog);
        if (hungry_dogs.isEmpty()) {
            return;
        }
        for (Dog hungry_dog : hungry_dogs) {
            this.checkAndFeedDog(dog, hungry_dog);
        }
    }

    private void checkAndFeedDog(Dog dog, Dog target) {
        if (target == dog) {
            this.tryFeed(dog, dog, false);
            return;
        }
        if (target.isBusy()) {
            return;
        }
        if (target.m_21825_()) {
            return;
        }
        if (target.m_21827_()) {
            return;
        }
        if (!this.hasFood(dog, target)) {
            return;
        }
        target.triggerAction(new DogEatFromChestDogAction(target, dog));
    }

    private boolean tryFeed(Dog dog, Dog feeder, boolean findHealingFood) {
        return DogFoodUtil.tryFeed(dog, feeder, findHealingFood, this.inventory());
    }

    private List<Dog> getNearbyHungryDogs(Dog dog) {
        List dogs = dog.m_9236_().m_6443_(Dog.class, dog.m_20191_().m_82377_(12.0, 4.0, 12.0), filter_dog -> this.isEligibleDog(dog, (Dog)filter_dog));
        return dogs;
    }

    private boolean isEligibleDog(Dog offerer, Dog target) {
        if (!this.isHungryDog(target)) {
            return false;
        }
        UUID ownerUUID = offerer.m_21805_();
        if (ownerUUID == null) {
            return false;
        }
        return offerer.willObeyOthers() || !ObjectUtils.notEqual((Object)ownerUUID, (Object)target.m_21805_());
    }

    private boolean isHungryDog(Dog dog) {
        return dog.isDoingFine() && dog.getDogHunger() < 25.0f;
    }

    @Override
    public void set(AbstractDog dog, int preLevel) {
        if (preLevel > 0 && this.level == 0) {
            this.dropInventory(dog);
        }
    }

    @Override
    public void dropInventory(AbstractDog dogIn) {
        if (dogIn.m_9236_().f_46443_) {
            return;
        }
        if (dogIn.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
            return;
        }
        for (int i = 0; i < this.packPuppyHandler.getSlots(); ++i) {
            Containers.m_18992_((Level)dogIn.m_9236_(), (double)dogIn.m_20185_(), (double)dogIn.m_20186_(), (double)dogIn.m_20189_(), (ItemStack)this.packPuppyHandler.getStackInSlot(i));
            this.packPuppyHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        compound.m_128391_(this.packPuppyHandler.serializeNBT());
        compound.m_128379_("renderChest", this.renderChest);
        compound.m_128379_("pickupNearby", this.pickupItems);
        compound.m_128379_("offerFood", this.offerFood);
        compound.m_128379_("collectKillLoot", this.collectKillLoot);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.packPuppyHandler.deserializeNBT(compound);
        this.renderChest = compound.m_128471_("renderChest");
        this.pickupItems = compound.m_128471_("pickupNearby");
        this.offerFood = compound.m_128471_("offerFood");
        this.collectKillLoot = compound.m_128471_("collectKillLoot");
    }

    @Override
    public void onRead(AbstractDog dogIn, CompoundTag compound) {
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public boolean hasRenderer() {
        return (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_CHEST);
    }

    public static boolean hasInventory(AbstractDog dogIn) {
        return dogIn.isDoingFine() && dogIn.getTalent((Supplier)DoggyTalents.PACK_PUPPY).isPresent();
    }

    public boolean hasFood(Dog finder, Dog forWho) {
        return DogFoodUtil.dogFindFoodInInv(finder, forWho, false, this.inventory()) >= 0;
    }

    public static PackPuppyTalent getInstanceFromDog(AbstractDog dog) {
        return dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class)).orElse(null);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.PACK_PUPPY_RENDER.get()) {
            return this.renderChest;
        }
        if (entry == TalentsOptions.PACK_PUPPY_PICKUP.get()) {
            return this.pickupItems;
        }
        if (entry == TalentsOptions.PACK_PUPPY_FOOD.get()) {
            return this.offerFood;
        }
        if (entry == TalentsOptions.PACK_PUPPY_LOOT.get()) {
            return this.collectKillLoot;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.PACK_PUPPY_RENDER.get()) {
            this.renderChest = (Boolean)data;
        }
        if (entry == TalentsOptions.PACK_PUPPY_PICKUP.get()) {
            this.pickupItems = (Boolean)data;
        }
        if (entry == TalentsOptions.PACK_PUPPY_FOOD.get()) {
            this.offerFood = (Boolean)data;
        }
        if (entry == TalentsOptions.PACK_PUPPY_LOOT.get()) {
            this.collectKillLoot = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.PACK_PUPPY_RENDER.get(), TalentsOptions.PACK_PUPPY_LOOT.get(), TalentsOptions.PACK_PUPPY_PICKUP.get(), TalentsOptions.PACK_PUPPY_FOOD.get());
    }

    public boolean renderChest() {
        return this.renderChest;
    }

    public void setRenderChest(boolean render) {
        this.renderChest = render;
    }

    public boolean pickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean val) {
        this.pickupItems = val;
    }

    public boolean offerFood() {
        return this.offerFood;
    }

    public void setOfferFood(boolean val) {
        this.offerFood = val;
    }

    public boolean collectKillLoot() {
        return this.collectKillLoot;
    }

    public void setCollectKillLoot(boolean val) {
        this.collectKillLoot = val;
    }

    public static void mayNotifyNearbyPackPuppy(LivingDropsEvent event) {
        boolean eligibleKiller;
        DamageSource source = event.getSource();
        LivingEntity killed = event.getEntity();
        Entity killer = source.m_7639_();
        if (killer == null) {
            return;
        }
        if (killer.m_9236_().f_46443_) {
            return;
        }
        Collection drops = event.getDrops();
        if (drops.isEmpty()) {
            return;
        }
        if (!(killer instanceof LivingEntity)) {
            return;
        }
        LivingEntity killerLiving = (LivingEntity)killer;
        boolean bl = eligibleKiller = killerLiving instanceof Player || killerLiving instanceof Dog;
        if (!eligibleKiller) {
            return;
        }
        Optional<Dog> dogOptional = PackPuppyTalent.findNearestChestDogToNotify(killerLiving);
        if (!dogOptional.isPresent()) {
            return;
        }
        Dog dog = dogOptional.get();
        dog.triggerAction(new DogCollectLootAction(dog, killed.m_20183_()));
    }

    private static Optional<Dog> findNearestChestDogToNotify(LivingEntity killer) {
        List dogs = killer.m_9236_().m_6443_(Dog.class, killer.m_20191_().m_82377_((double)NOTIFY_RADIUS, 3.0, (double)NOTIFY_RADIUS), filter_dog -> PackPuppyTalent.isValidItemCollector(filter_dog, killer));
        if (dogs.isEmpty()) {
            return Optional.empty();
        }
        Dog selected_dog = (Dog)dogs.get(0);
        double min_dist = selected_dog.m_20280_((Entity)killer);
        for (Dog dog : dogs) {
            double dist = dog.m_20280_((Entity)killer);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            selected_dog = dog;
        }
        return Optional.ofNullable(selected_dog);
    }

    private static boolean isValidItemCollector(Dog dog, LivingEntity killer) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        if (killer == dog) {
            return false;
        }
        UUID ownerUUID = dog.m_21805_();
        if (ownerUUID == null) {
            return false;
        }
        UUID killerOwnerUUID = null;
        if (killer instanceof Player) {
            Player player = (Player)killer;
            killerOwnerUUID = player.m_20148_();
        } else if (killer instanceof Dog) {
            Dog killerDog = (Dog)killer;
            killerOwnerUUID = dog.m_21805_();
        }
        if (killerOwnerUUID == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)ownerUUID, (Object)killerOwnerUUID)) {
            return false;
        }
        Optional instOptional = dog.getTalent((Supplier)DoggyTalents.PACK_PUPPY);
        if (!instOptional.isPresent()) {
            return false;
        }
        TalentInstance inst = (TalentInstance)instOptional.get();
        if (!(inst instanceof PackPuppyTalent)) {
            return false;
        }
        PackPuppyTalent packPup = (PackPuppyTalent)inst;
        if (!packPup.canCollectItems()) {
            return false;
        }
        if (!packPup.pickupItems()) {
            return false;
        }
        if (!packPup.collectKillLoot()) {
            return false;
        }
        PackPuppyItemHandler inv = packPup.inventory();
        if (inv == null) {
            return false;
        }
        boolean hasFreeSlot = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!stack.m_41619_()) continue;
            hasFreeSlot = true;
            break;
        }
        return hasFreeSlot;
    }

    public static class DogEatFromChestDogAction
    extends TriggerableAction {
        private Dog target;
        private int tickTillPathRecalc;
        private final int stopDist = 2;
        private boolean enoughHealingFood = false;
        private int goToTimeout = 0;
        private int feedCooldown = 0;
        private boolean failedEating = false;

        public DogEatFromChestDogAction(Dog dog, Dog target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            this.goToTimeout = 200;
        }

        @Override
        public void tick() {
            boolean is_close_to_target;
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.enoughEating()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.failedEating) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = is_close_to_target = this.dog.m_20280_((Entity)this.target) <= 4.0;
            if (!is_close_to_target) {
                --this.goToTimeout;
            }
            if (this.goToTimeout <= 0 && !is_close_to_target) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.feedCooldown > 0) {
                --this.feedCooldown;
            }
            if (!is_close_to_target) {
                this.dog.m_21563_().m_24960_((Entity)this.target, 10.0f, (float)this.dog.m_8132_());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.m_21523_() && !this.dog.m_20159_()) {
                        this.dog.m_21573_().m_5624_((Entity)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.m_21573_().m_26573_();
                this.checkAndEat();
            }
        }

        @Override
        public void onStop() {
        }

        private boolean enoughEating() {
            float hunger = this.dog.getDogHunger();
            if (hunger < 80.0f) {
                return false;
            }
            return !this.dog.isDogLowHealth() || !(hunger < this.dog.getMaxHunger());
        }

        private void checkAndEat() {
            boolean dogNeedsHealing;
            if (this.feedCooldown > 0) {
                return;
            }
            PackPuppyTalent inst = PackPuppyTalent.getInstanceFromDog(this.target);
            if (inst == null) {
                return;
            }
            boolean bl = dogNeedsHealing = this.dog.isDogLowHealth() && !this.dog.m_21023_(MobEffects.f_19605_);
            if (!this.enoughHealingFood && dogNeedsHealing) {
                this.enoughHealingFood = true;
                this.failedEating = !inst.tryFeed(this.dog, this.target, true);
            } else {
                this.failedEating = !inst.tryFeed(this.dog, this.target, false);
            }
            this.feedCooldown = this.dog.m_217043_().m_188503_(11);
        }

        private boolean stillValidTarget() {
            if (!this.target.m_6084_()) {
                return false;
            }
            if (this.dog.m_20280_((Entity)this.target) > 256.0) {
                return false;
            }
            PackPuppyTalent inst = PackPuppyTalent.getInstanceFromDog(this.target);
            if (inst == null) {
                return false;
            }
            return inst.hasFood(this.target, this.dog);
        }
    }

    public static class DogCollectLootAction
    extends TriggerableAction {
        private BlockPos target;

        public DogCollectLootAction(Dog dog, @NonNull BlockPos target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            if (this.dog.m_20238_(Vec3.m_82539_((Vec3i)this.target)) > 256.0) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.dog.m_21573_().m_26573_();
            DogUtil.moveToIfReachOrElse(this.dog, this.target, this.dog.getUrgentSpeedModifier(), 1, 1, d -> {
                this.target = null;
            });
        }

        @Override
        public void tick() {
            if (this.target == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.m_21573_().m_26571_()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }

        @Override
        public void onStop() {
        }
    }
}

